//------------------------------------------------
// O[oϐ
//------------------------------------------------
float4x4	g_world;			//[hϊs
float4x4	g_inv_world;		//[hϊts
float4x4	g_view;				//r[ϊs
float4x4	g_proj;				//eϊs

float4x4	g_shadow_vproj0;	//VhE}bvpr[eϊs
float4x4	g_shadow_vproj1;	//VhE}bvpr[eϊs
float4x4	g_shadow_vproj2;	//VhE}bvpr[eϊs
float4x4	g_shadow_vproj3;	//VhE}bvpr[eϊs

float4		g_light_color;		//F
float4		g_ref_color;		//ʔːF
float4		g_env_color;		//F
float4		g_light_dir;		//Cg̓eiuΏۃsNZvxNgj
float4		g_camera_pos;		//J̍W
float		g_emphasis;			//_OFx
texture		g_texture;			//eNX`
texture		g_env_texture;		//eNX`
texture		g_bump_texture;		//oveNX`
texture		g_specular_texture;	//XyLeNX`
texture		g_shadow_texture0;	//VhE}bveNX`
texture		g_shadow_texture1;	//VhE}bveNX`
texture		g_shadow_texture2;	//VhE}bveNX`
texture		g_shadow_texture3;	//VhE}bveNX`

float		g_fog_start;		//tHOJn
float		g_fog_end;			//tHOB
float4		g_fog_color;		//tHOF

float		g_shadow_size;		//VhE}bṽTCY

float		g_texture_width;	//eNX`
float		g_texture_height;	//eNX`

//------------------------------------------------
// eNX`Tv
//------------------------------------------------
sampler TextureSampler = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_texture>;
};
sampler EnvTextureSampler = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_env_texture>;
};
sampler BumpTextureSampler = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_bump_texture>;
};
sampler SpecularTextureSampler = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_specular_texture>;
};
sampler ShadowTextureSampler0 = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_shadow_texture0>;
};

sampler ShadowTextureSampler1 = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_shadow_texture1>;
};
sampler ShadowTextureSampler2 = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_shadow_texture2>;
};
sampler ShadowTextureSampler3 = 
sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
    Texture = <g_shadow_texture3>;
};

//------------------------------------------------
// _VF[_
//------------------------------------------------
//XvCg`iȂǂlȂj
void SpriteVS( 	float3 in_pos	:POSITION,
				float4 in_col	:COLOR0,
				float2 in_tex	:TEXCOORD0,
				out float4 out_pos	:POSITION,
				out float4 out_color:COLOR0,
				out float  out_fog	:FOG,
				out float2 out_tex	:TEXCOORD0,
				out float4 out_w_pos:TEXCOORD1,
				out float3 out_w_normal	:TEXCOORD2)
{
	float4 v_pos;
	
	// Wϊ
	out_w_pos = mul(float4(in_pos, 1.0f), g_world);		//̌vZŎĝŃ[hW͕ϐɓĂ
	v_pos=mul(out_w_pos, g_view);		//J猩Wi[itHOvZŎgpj
	out_pos = mul(mul(out_w_pos, g_view), g_proj);		//܂Ƃ߂ĉʍW܂ŕϊ
	
	// _̐F̌
	out_color = in_col;

	// eNX`W̓Rs[邾
	out_tex = in_tex;

	//sNZVF[_֓n@xNgixNgnČvZIɖɂj
	out_w_normal = normalize(g_light_dir.xyz);

	//tHOlvZ
	out_fog = (length(v_pos.xyz)-g_fog_start)/(g_fog_end-g_fog_start);
}

//bVt@Ceƌĕ`
void MeshVS( 	float3 in_pos		:POSITION,
				float3 in_normal	:NORMAL,
				float4 in_col		:COLOR0,
				float3 in_tangent	:TANGENT,
				float3 in_binormal	:BINORMAL,
				float2 in_tex		:TEXCOORD0,
				out float4 out_pos		:POSITION,
				out float4 out_color	:COLOR0,
				out float  out_fog		:FOG,
				out float2 out_tex		:TEXCOORD0,
				out float4 out_w_pos	:TEXCOORD1,
				out float3 out_env_tex	:TEXCOORD2,
				out float3 out_w_normal		:TEXCOORD3,
				out float3 out_w_tangent	:TEXCOORD4,
				out float3 out_w_binormal	:TEXCOORD5)
{
	float4 v_pos;
	
	// Wϊ
	out_w_pos = mul(float4(in_pos, 1.0f), g_world);		//̌vZŎĝŃ[hW͕ϐɓĂ
	v_pos=mul(out_w_pos, g_view);		//J猩Wi[itHOvZŎgpj
	out_pos = mul(v_pos, g_proj);		//܂Ƃ߂ĉʍW܂ŕϊ
	
	//[hWn̖@xNgUVxNg
	out_w_normal = normalize(mul(float4(in_pos+in_normal, 1.0f), g_world) - out_w_pos);		//@xNg[hWɕϊ
	out_w_tangent = normalize(mul(float4(in_pos+in_tangent, 1.0f), g_world) - out_w_pos);	//ڃxNg[hWɕϊ
	out_w_binormal = normalize(mul(float4(in_pos+in_binormal, 1.0f), g_world) - out_w_pos);	//]@xNg[hWɕϊ
	
	// _̐F߂iCeBO̓sNZVF[_ōsj
	out_color = in_col;
	
	//sNZVF[_֓n@xNgiʔ˂̌vZŎgj
	float3 w_normal = normalize( mul(in_normal, g_world));
	
	//sNZVF[_֓n}bsOpeNX`W
	out_env_tex = normalize( mul(mul(w_normal, g_view), g_proj))*2;
	
	// eNX`W̓Rs[邾
	out_tex = in_tex;
	
	//tHOlvZ
	out_fog = (v_pos.z-g_fog_start)/(g_fog_end-g_fog_start);
}

//VhE}bvpiϊWój
void ShadowVS( 	float3 in_pos	:POSITION,
				float4 in_col	:COLOR0,
				out float4 out_depth:TEXCOORD0,
				out float4 out_pos	:POSITION,
				out float4 out_color:COLOR0)
{
	// Wϊ
	out_pos = mul(mul(mul(float4(in_pos, 1.0f), g_world), g_view), g_proj);

	// _̐F̌
	out_color = in_col;

	//ϊ̒_Wo
	out_depth = out_pos;
}

//------------------------------------------------
// sNZVF[_
//------------------------------------------------
//ʏ̃eNX`ǂݏo
void SpritePS(	float4 in_color		:COLOR0,
				float4 in_tex		:TEXCOORD0,
				out float4 out_color:COLOR0)
{	
	//F̏o
	out_color = tex2D(TextureSampler, in_tex)*in_color;
}
//AiOtp̍ڃeNX`ǂݏo
void SpritePS_L(	float4 in_color		:COLOR0,
					float4 in_tex		:TEXCOORD0,
					out float4 out_color:COLOR0)
{	
	float4x4 col_matrix=float4x4(0.4155,-0.0458,-0.0545,0, 0.4710,-0.0484,-0.0614,0, 0.1670,-0.0258,0.0128,0, 0,0,0,1);
	//F̏o
	out_color = tex2D(TextureSampler, in_tex)*in_color;
	out_color = mul(out_color, col_matrix);
}
//AiOtp̉EڃeNX`ǂݏo
void SpritePS_R(	float4 in_color		:COLOR0,
					float4 in_tex		:TEXCOORD0,
					out float4 out_color:COLOR0)
{	
	float4x4 col_matrix=float4x4(-0.0109,0.3756,-0.0651,0, -0.0365,0.7333,-0.1286,0, -0.0060,0.0111,1.2968,0, 0,0,0,1);
	//F̏o
	out_color = tex2D(TextureSampler, in_tex)*in_color;
	out_color = mul(out_color, col_matrix);
}
//3DXvCgp̃eNX`ǂݏo
void Sprite3DPS(	float4 in_color		:COLOR0,
					//float  in_fog		:FOG,
					float4 in_tex		:TEXCOORD0,
					out float4 out_color:COLOR0)
{	
	//F̏o
	float4 tex_color;
	tex_color=tex2D(TextureSampler, in_tex);
	out_color = saturate( tex_color * in_color * g_emphasis);

	//out_color=lerp(out_color, g_fog_color, in_fog);			//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;		//͂Ȃƃ_ۂ
}
//3DbVp̃eNX`ǂݏo
void MeshPS(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color	:COLOR0)
{	
	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float4	light_color;																//\ʊgUF
	float	dif_rate;																	//\ʊgUF̋
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	light_color = (g_env_color + g_light_color * dif_rate) * in_color;					//\ʊgUF̌vZ


	/*------  F̏o  ------*/
	float4 tex_color;																	//eNX`F
	tex_color= tex2D(TextureSampler, in_tex);
	out_color = saturate(tex_color*light_color*g_emphasis);								//\ʊgUF


	/*------  tHOvZ  ------*/
	out_color=lerp(out_color, g_fog_color, saturate(in_fog));							//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;												//͂Ȃƃ_ۂ
}

//3DbVp̃eNX`ǂݏo
void MeshPS_S(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color:COLOR0)
{	
	/*------  VhE}bvɂxvZ  ------*/
	float4	s_pos;			//VhE}bvvZp̈ꎞϐ
	float4	abs_pos;		//
	float4	shadow_tex;		//VhE}bv̍W

	float light_rate;		//xtO
	light_rate=1.0f;		//Ƃ肠͌100%Ă̂Ƃ

	float block_rate;		//̎ՂtO
	block_rate=0.0f;		//Ƃ肠͉ՂĂȂ̂Ƃ

	float x_flag, y_flag, z_flag, shadow_block;
	float in_shadow_cube0, in_shadow_cube1, in_shadow_cube2, in_shadow_cube3;


	s_pos = mul(in_w_pos, g_shadow_vproj0);		//sNZ̍WVhE}bv[0]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.z = saturate(s_pos.z);
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f);				//Zl0艜Ȃ1AȊO0
	in_shadow_cube0=x_flag*y_flag*z_flag;			//VhE}bv͈͓̔Ȃ1ȊO0
	
	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0;						//VhE}bv̉e̒ȂΖ邳[ɂ


	s_pos = mul(in_w_pos, g_shadow_vproj1);		//sNZ̍WVhE}bv[1]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube1=x_flag*y_flag*z_flag;							//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1;						//VhE}bv̉e̒ȂΖ邳[ɂ


	s_pos = mul(in_w_pos, g_shadow_vproj2);		//sNZ̍WVhE}bv[2]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube2=x_flag*y_flag*z_flag*(1-in_shadow_cube1);		//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2;						//VhE}bv̉e̒ȂΖ邳[ɂ


	s_pos = mul(in_w_pos, g_shadow_vproj3);		//sNZ̍WVhE}bv[3]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube3=x_flag*y_flag*z_flag*(1-in_shadow_cube1)*(1-in_shadow_cube2);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3;						//VhE}bv̉e̒ȂΖ邳[ɂ

	light_rate=light_rate*saturate(1-block_rate);					//̎Ղ蕪Â


	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float4	light_color;																//\ʊgUF
	float	dif_rate;																	//\ʊgUF̋
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	light_color = (g_env_color + light_rate * g_light_color * dif_rate) * in_color;		//\ʊgUF̌vZ


	/*------  F̏o  ------*/
	float4 tex_color;																	//eNX`F
	tex_color= tex2D(TextureSampler, in_tex);
	out_color = saturate(tex_color*light_color*g_emphasis);								//\ʊgUF


	/*------  tHOvZ  ------*/
	out_color=lerp(out_color, g_fog_color, saturate(in_fog));							//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;												//͂Ȃƃ_ۂ
}

//3DbVp̃eNX`ǂݏo
void MeshPS_S8(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color:COLOR0)
{	
	float4 light_color;	//\ʊgUF
	
	/*------  VhE}bvɂxvZ  ------*/
	float4	s_pos;			//VhE}bvvZp̈ꎞϐ
	float4	abs_pos;		//
	float4	shadow_tex;		//VhE}bv̍W

	float light_rate;		//xtO
	light_rate=1.0f;		//Ƃ肠͌100%Ă̂Ƃ

	float block_rate;		//̎ՂtO
	block_rate=0.0f;		//Ƃ肠͉ՂĂȂ̂Ƃ

	float x_flag, y_flag, z_flag, shadow_block;
	float in_shadow_cube, in_shadow_cube0, in_shadow_cube1, in_shadow_cube2, in_shadow_cube3;


	s_pos = mul(in_w_pos, g_shadow_vproj0);		//sNZ̍WVhE}bv[0]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.z = saturate(s_pos.z);
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f);				//Zl0艜Ȃ1AȊO0
	in_shadow_cube0=x_flag*y_flag*z_flag;			//VhE}bv͈͓̔Ȃ1ȊO0
	
	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj1);		//sNZ̍WVhE}bv[1]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube1=x_flag*y_flag*z_flag;		//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj2);		//sNZ̍WVhE}bv[2]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube2=x_flag*y_flag*z_flag*(1-in_shadow_cube1);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj3);		//sNZ̍WVhE}bv[3]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube3=x_flag*y_flag*z_flag*(1-in_shadow_cube1)*(1-in_shadow_cube2);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float dif_rate;																		//\ʊgUF̋
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	light_color = (g_env_color + light_rate * g_light_color * dif_rate) * in_color;		//\ʊgUF̌vZ


	/*------  F̏o  ------*/
	float4 tex_color;																	//eNX`F
	tex_color= tex2D(TextureSampler, in_tex);											//eNX`Fǂݏo
	out_color = saturate(tex_color*light_color*g_emphasis);								//\ʊgUF


	/*------  tHOvZ  ------*/
	out_color=lerp(out_color, g_fog_color, saturate(in_fog));							//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;												//͂Ȃƃ_ۂ
}

//bVp̃eNX`ǂݏoʔːF
void EnvMeshPS(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color	:COLOR0)
{	
	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float4	light_color;																//\ʊgUF
	float	dif_rate;																	//\ʊgUF̋
	float	ref_rate;																	//ʔːF̍ő勭
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	light_color = (g_env_color + g_light_color * dif_rate) * in_color;					//\ʊgUF̌vZ
	
	ref_rate=saturate(dif_rate*100);													//e̕ŋʔ˂Ȃ߂ɁA\ʊgUT`点i̋ʔːFvZŎgpj

	/*------  ʔːF̌vZ  ------*/	
	float4	ref_color;																	//ʔːF
	float	specular;																	//ʔˋx
	specular=tex2D(SpecularTextureSampler, in_tex).x;									//XyL}bv狾ʔˋxǂ
	float3 eye_dir;																		//uΏۃsNZJvxNg
	float3 half_dir;																	//n[txNg
	eye_dir = normalize(g_camera_pos.xyz - in_w_pos.xyz);								//uΏۃsNZJṽ[hWxNg
	half_dir = normalize(eye_dir + g_light_dir.xyz);									//uΏۃsNZJvƁuΏۃsNZṽn[txNg
	ref_color = specular * g_ref_color * (ref_rate * pow(max(0, dot(half_dir, w_normal)), 30) /*+tex2D(EnvTextureSampler, in_env_tex)/8*/);	//ʔːF̋ɊeNX`ZāACgxNgŐFt


	/*------  F̏o  ------*/
	float4 tex_color;																	//eNX`F
	tex_color= tex2D(TextureSampler, in_tex);											//eNX`Fǂݏo
	out_color = saturate(tex_color*light_color*g_emphasis + ref_color);					//ˊgUF+ʔːF


	/*------  tHOvZ  ------*/
	out_color=lerp(out_color, g_fog_color, saturate(in_fog));							//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;												//͂Ȃƃ_ۂ
}

//bVp̃eNX`ǂݏoʔːF
void EnvMeshPS_S(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color	:COLOR0)
{	
	/*------  VhE}bvɂxvZ  ------*/
	float4	s_pos;			//VhE}bvvZp̈ꎞϐ
	float4	abs_pos;		//
	float4	shadow_tex;		//VhE}bv̍W

	float light_rate;		//xtO
	light_rate=1.0f;		//Ƃ肠͌100%Ă̂Ƃ

	float block_rate;		//̎ՂtO
	block_rate=0.0f;		//Ƃ肠͉ՂĂȂ̂Ƃ

	float x_flag, y_flag, z_flag, shadow_block;
	float in_shadow_cube0, in_shadow_cube1, in_shadow_cube2, in_shadow_cube3;

	s_pos = mul(in_w_pos, g_shadow_vproj0);		//sNZ̍WVhE}bv[0]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.z = saturate(s_pos.z);
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f);				//Zl0艜Ȃ1AȊO0
	in_shadow_cube0=x_flag*y_flag*z_flag;			//VhE}bv͈͓̔Ȃ1ȊO0
	
	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0;						//VhE}bv̉e̒ȂΖ邳[ɂ


	s_pos = mul(in_w_pos, g_shadow_vproj1);		//sNZ̍WVhE}bv[1]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube1=x_flag*y_flag*z_flag;							//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1;						//VhE}bv̉e̒ȂΖ邳[ɂ


	s_pos = mul(in_w_pos, g_shadow_vproj2);		//sNZ̍WVhE}bv[2]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube2=x_flag*y_flag*z_flag*(1-in_shadow_cube1);		//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2;						//VhE}bv̉e̒ȂΖ邳[ɂ


	s_pos = mul(in_w_pos, g_shadow_vproj3);		//sNZ̍WVhE}bv[3]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube3=x_flag*y_flag*z_flag*(1-in_shadow_cube1)*(1-in_shadow_cube2);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));									//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);			//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3;						//VhE}bv̉e̒ȂΖ邳[ɂ

	light_rate=light_rate*saturate(1-block_rate);					//̎Ղ蕪Â


	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float4	light_color;																//\ʊgUF
	float	dif_rate;																	//\ʊgUF̋
	float	ref_rate;																	//\ʔːF̍ő勭
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	light_color = (g_env_color + light_rate * g_light_color * dif_rate) * in_color;		//\ʊgUF̌vZ
	
	ref_rate=saturate(dif_rate*100);													//e̕ŋʔ˂Ȃ߂ɁA\ʊgUT`点i̋ʔːFvZŎgpj

	/*------  ʔːF̌vZ  ------*/	
	float4	ref_color;																	//ʔːF
	float	specular;																	//ʔˋx
	specular=tex2D(SpecularTextureSampler, in_tex).x;									//XyL}bv狾ʔˋxǂ
	float3	eye_dir;																	//uΏۃsNZJvxNg
	float3	half_dir;																	//n[txNg
	eye_dir = normalize(g_camera_pos.xyz - in_w_pos.xyz);								//uΏۃsNZJṽ[hWxNg
	half_dir = normalize(eye_dir + g_light_dir.xyz);									//uΏۃsNZJvƁuΏۃsNZṽn[txNg
	ref_color = specular * g_ref_color * (ref_rate * light_rate * pow(max(0, dot(half_dir, w_normal)), 30) /*+tex2D(EnvTextureSampler, in_env_tex)/8*/);	//ʔːF̋ɊeNX`ZāACgxNgŐFt


	/*------  F̏o  ------*/
	float4 tex_color;																	//eNX`F
	tex_color= tex2D(TextureSampler, in_tex);											//eNX`Fǂݏo
	out_color = saturate(tex_color*light_color*g_emphasis + ref_color);					//ˊgUF+ʔːF


	/*------  tHOvZ  ------*/
	out_color=lerp(out_color, g_fog_color, saturate(in_fog));							//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;												//͂Ȃƃ_ۂ
}

//bVp̃eNX`ǂݏoʔːF
void EnvMeshPS_S8(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color	:COLOR0)
{	
	/*------  VhE}bvɂxvZ  ------*/
	float4	s_pos;			//VhE}bvvZp̈ꎞϐ
	float4	abs_pos;		//
	float4	shadow_tex;		//VhE}bv̍W

	float light_rate;		//xtO
	light_rate=1.0f;		//Ƃ肠͌100%Ă̂Ƃ

	float block_rate;		//̎ՂtO
	block_rate=0.0f;		//Ƃ肠͉ՂĂȂ̂Ƃ


	float x_flag, y_flag, z_flag, shadow_block;
	float in_shadow_cube, in_shadow_cube0, in_shadow_cube1, in_shadow_cube2, in_shadow_cube3;


	s_pos = mul(in_w_pos, g_shadow_vproj0);		//sNZ̍WVhE}bv[0]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.z = saturate(s_pos.z);
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)		;		//Zl0艜Ȃ1AȊO0
	in_shadow_cube0=x_flag*y_flag*z_flag;			//VhE}bv͈͓̔Ȃ1ȊO0
	
	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj1);		//sNZ̍WVhE}bv[1]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube1=x_flag*y_flag*z_flag;		//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj2);		//sNZ̍WVhE}bv[2]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube2=x_flag*y_flag*z_flag*(1-in_shadow_cube1);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj3);			//sNZ̍WVhE}bv[3]̒̍Wɕϊ
	abs_pos = abs(s_pos);							//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;		//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;		//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube3=x_flag*y_flag*z_flag*(1-in_shadow_cube1)*(1-in_shadow_cube2);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler3, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube3*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float4	light_color;																//\ʊgUF
	float	dif_rate;																	//\ʊgUF̋
	float	ref_rate;																	//\ʔːF̍ő勭
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	light_color = (g_env_color + light_rate * g_light_color * dif_rate) * in_color;		//\ʊgUF̌vZ
	
	ref_rate=saturate(dif_rate*100);													//e̕ŋʔ˂Ȃ߂ɁA\ʊgUT`点i̋ʔːFvZŎgpj

	/*------  ʔːF̌vZ  ------*/	
	float4	ref_color;																	//ʔːF
	float	specular;																	//ʔˋx
	specular=tex2D(SpecularTextureSampler, in_tex).x;									//XyL}bv狾ʔˋxǂ
	float3	eye_dir;																	//uΏۃsNZJvxNg
	float3	half_dir;																	//n[txNg
	eye_dir = normalize(g_camera_pos.xyz - in_w_pos.xyz);								//uΏۃsNZJṽ[hWxNg
	half_dir = normalize(eye_dir + g_light_dir.xyz);									//uΏۃsNZJvƁuΏۃsNZṽn[txNg
	ref_color = specular * g_ref_color * (ref_rate * light_rate * pow(max(0, dot(half_dir, w_normal)), 30) /*+tex2D(EnvTextureSampler, in_env_tex)/8*/);	//ʔːF̋ɊeNX`ZāACgxNgŐFt


	/*------  F̏o  ------*/
	float4 tex_color;																	//eNX`F
	tex_color= tex2D(TextureSampler, in_tex);											//eNX`Fǂݏo
	out_color = saturate(tex_color*light_color*g_emphasis + ref_color);					//ˊgUF+ʔːF


	/*------  tHOvZ  ------*/
	out_color=lerp(out_color, g_fog_color, saturate(in_fog));							//tHOJ[Kp
	out_color.a = tex_color.a*in_color.a;												//͂Ȃƃ_ۂ
}

//VhE}bvp̃eNX`ǂݏo
void ShadowPS(	float4 in_color		:COLOR0,
				float4 in_depth		:TEXCOORD0,
				out float4 out_color	:COLOR0)
{	
	//F̏o
	out_color = float4(1.0, 1.0, 1.0, 1.0)*(1.0f-in_depth.z);
	out_color.a = in_color.a;		//͂Ȃƃ_ۂ
}

//OA}bvp̃eNX`ǂݏo
void GlarePS(	float4 in_color		:COLOR0,
				float  in_fog		:FOG,
				float4 in_tex		:TEXCOORD0,
				float4 in_w_pos		:TEXCOORD1,
				float3 in_env_tex	:TEXCOORD2,
				float3 in_w_normal	:TEXCOORD3,
				float3 in_w_tangent	:TEXCOORD4,
				float3 in_w_binormal:TEXCOORD5,
				out float4 out_color:COLOR0)
{	

	//VhE}bv̋tvZ
	float4 s_pos;
	float4 abs_pos;
	float4 shadow_tex;
	
	float light_rate;	//xtO
	light_rate=1.0f;	//Ƃ肠͌100%Ă̂Ƃ

	float block_rate;	//̎ՂtO
	block_rate=0.0f;	//Ƃ肠͉ՂĂȂ̂Ƃ


	float x_flag, y_flag, z_flag, shadow_block;
	float in_shadow_cube, in_shadow_cube0, in_shadow_cube1, in_shadow_cube2, in_shadow_cube3;


	s_pos = mul(in_w_pos, g_shadow_vproj0);		//sNZ̍WVhE}bv[0]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.z = saturate(s_pos.z);
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)		;		//Zl0艜Ȃ1AȊO0
	in_shadow_cube0=x_flag*y_flag*z_flag;			//VhE}bv͈͓̔Ȃ1ȊO0
	
	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler0, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube0*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj1);		//sNZ̍WVhE}bv[1]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube1=x_flag*y_flag*z_flag;		//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler1, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube1*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	s_pos = mul(in_w_pos, g_shadow_vproj2);		//sNZ̍WVhE}bv[2]̒̍Wɕϊ
	abs_pos = abs(s_pos);						//Βl
	s_pos.x = 0.5f+s_pos.x*0.5f+g_shadow_size;	//XWeNX`Wnɕϊ
	s_pos.y = 0.5f-s_pos.y*0.5f+g_shadow_size;	//YWeNX`Wnɕϊ

	x_flag=saturate((0.98f-abs_pos.x)*32768.0f);	//XΒl0.98Ȃ1AȊO0
	y_flag=saturate((0.98f-abs_pos.y)*32768.0f);	//YΒl0.98Ȃ1AȊO0
	z_flag=saturate(s_pos.z*32768.0f)*saturate((1-s_pos.z)*32768.0f);		//Zl0艜Ȃ1AȊO0
	in_shadow_cube2=x_flag*y_flag*z_flag*(1-in_shadow_cube1);			//VhE}bv͈͓̔Ȃ1ȊO0

	s_pos.z=(1-(s_pos.z-0.0001f));											//ZW[ɕϊ
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.2f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y+2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x-2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x                , s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y-2*g_shadow_size, 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷
	shadow_tex=tex2D(ShadowTextureSampler2, float4(s_pos.x+2*g_shadow_size, s_pos.y                , 0, 0));	//VhE}bvǂݏo
	shadow_block=saturate((shadow_tex.x-s_pos.z)*32768.0f);					//Ă1AȊO0
	block_rate+=shadow_block*in_shadow_cube2*0.1f;							//VhE}bv̉e̒ȂΖ邳炷

	light_rate=light_rate*saturate(1-block_rate);							//̎Ղ蕪ʌ炷


	/*------  ov}bv@xNǧvZ(gUƔˌ̗Ŏgp)  ------*/
	float3	vec_bump;																	//ov@xNg
	vec_bump=tex2D(BumpTextureSampler, in_tex);											//ov}bvǂݏo
	vec_bump=vec_bump*2-1;																//UVɂ(0`1)̍W͈͂(-1`+1)ɕϊ
	vec_bump.z=-1;																		//O}CiX
	vec_bump=normalize(vec_bump);														//ŌɒPʍsɂĂ
	float3 w_normal;																	//@xNg
	w_normal=normalize(in_w_normal + vec_bump.y*in_w_tangent+vec_bump.x*in_w_binormal);	//ov}bvl[hWn@xNg


	/*------  \ʊgUF̌vZ  ------*/
	float	dif_rate;																	//\ʊgUF̋
	float	ref_rate;																	//\ʔːF̍ő勭
	dif_rate=max(0.0f, dot(w_normal, g_light_dir));										//ov܂ޖ@xNgɂ郉CeBOvZ
	ref_rate=saturate(dif_rate*100);													//e̕ŋʔ˂Ȃ߂ɁA\ʊgUT`点i̋ʔːFvZŎgpj

	/*------  ʔːF̌vZ  ------*/	
	float4	ref_color;																	//ʔːF
	float	specular;																	//ʔˋx
	specular=tex2D(SpecularTextureSampler, in_tex).x;									//XyL}bv狾ʔˋxǂ
	float3	eye_dir;																	//uΏۃsNZJvxNg
	float3	half_dir;																	//n[txNg
	eye_dir = normalize(g_camera_pos.xyz - in_w_pos.xyz);								//uΏۃsNZJṽ[hWxNg
	half_dir = normalize(eye_dir + g_light_dir.xyz);									//uΏۃsNZJvƁuΏۃsNZṽn[txNg
	out_color = specular * g_ref_color * (ref_rate * light_rate * pow(max(0, dot(half_dir, w_normal)), 30));	//ʔːF̋ɊeNX`ZāACgxNgŐFt

	out_color.a = in_color.a;		//͂Ȃƃ_ۂ
}

//1/4kRs[p̃eNX`ǂݏo
void SmallPS(	float4 in_color		:COLOR0,
				float4 in_tex		:TEXCOORD0,
				out float4 out_color	:COLOR0)
{	
	//F̏o
	out_color = tex2D(TextureSampler, in_tex+float4(0, 0, 0, 0))*in_color/4;
	out_color += tex2D(TextureSampler, in_tex+float4(0, 0.5f/g_texture_height, 0, 0))*in_color/4;
	out_color += tex2D(TextureSampler, in_tex+float4(0.5f/g_texture_width, 0, 0, 0))*in_color/4;
	out_color += tex2D(TextureSampler, in_tex+float4(0.5f/g_texture_width, 0.5f/g_texture_height, 0, 0))*in_color/4;
}

//\L΂Rs[p̃eNX`ǂݏo
void CrossPS(	float4 in_color		:COLOR0,
				float4 in_tex		:TEXCOORD0,
				out float4 out_color	:COLOR0)
{	
	//F̏o
	out_color = tex2D(TextureSampler, in_tex);
	float f;
	float4 cross_vec_r;
	float4 cross_vec_g;
	float4 cross_vec_b;
	
	
	cross_vec_r = float4(0.0f/g_texture_width, 1.0f/g_texture_height, 0, 0);
	cross_vec_g = cross_vec_r*0.95f;
	cross_vec_b = cross_vec_r*0.9f;
	for (f=1;f<25;f+=1.0f) {
//		out_color += tex2D(TextureSampler, in_tex+cross_vec_r*f)*(25-f)/25;
		out_color.x += tex2D(TextureSampler, in_tex+cross_vec_r*f).x*(25-f)/25;
		out_color.y += tex2D(TextureSampler, in_tex+cross_vec_g*f).y*(25-f)/25;
		out_color.z += tex2D(TextureSampler, in_tex+cross_vec_b*f).z*(25-f)/25;
	}
	
	cross_vec_r = float4(0.866f/g_texture_width, 0.5f/g_texture_height, 0, 0);
	cross_vec_g = cross_vec_r*0.95f;
	cross_vec_b = cross_vec_r*0.9f;
	for (f=1;f<25;f+=1.0f) {
//		out_color += tex2D(TextureSampler, in_tex+cross_vec_r*f)*(25-f)/25;
		out_color.x += tex2D(TextureSampler, in_tex+cross_vec_r*f).x*(25-f)/25;
		out_color.y += tex2D(TextureSampler, in_tex+cross_vec_g*f).y*(25-f)/25;
		out_color.z += tex2D(TextureSampler, in_tex+cross_vec_b*f).z*(25-f)/25;
	}
	
	cross_vec_r = float4(0.866f/g_texture_width, -0.5f/g_texture_height, 0, 0);
	cross_vec_g = cross_vec_r*0.95f;
	cross_vec_b = cross_vec_r*0.9f;
	for (f=1;f<25;f+=1.0f) {
//		out_color += tex2D(TextureSampler, in_tex+cross_vec_r*f)*(25-f)/25;
		out_color.x += tex2D(TextureSampler, in_tex+cross_vec_r*f).x*(25-f)/25;
		out_color.y += tex2D(TextureSampler, in_tex+cross_vec_g*f).y*(25-f)/25;
		out_color.z += tex2D(TextureSampler, in_tex+cross_vec_b*f).z*(25-f)/25;
	}
	
	cross_vec_r = float4(0.0f/g_texture_width, -1.0f/g_texture_height, 0, 0);
	cross_vec_g = cross_vec_r*0.95f;
	cross_vec_b = cross_vec_r*0.9f;
	for (f=1;f<25;f+=1.0f) {
//		out_color += tex2D(TextureSampler, in_tex+cross_vec_r*f)*(25-f)/25;
		out_color.x += tex2D(TextureSampler, in_tex+cross_vec_r*f).x*(25-f)/25;
		out_color.y += tex2D(TextureSampler, in_tex+cross_vec_g*f).y*(25-f)/25;
		out_color.z += tex2D(TextureSampler, in_tex+cross_vec_b*f).z*(25-f)/25;
	}
	
	cross_vec_r = float4(-0.866f/g_texture_width, -0.5f/g_texture_height, 0, 0);
	cross_vec_g = cross_vec_r*0.95f;
	cross_vec_b = cross_vec_r*0.9f;
	for (f=1;f<25;f+=1.0f) {
//		out_color += tex2D(TextureSampler, in_tex+cross_vec_r*f)*(25-f)/25;
		out_color.x += tex2D(TextureSampler, in_tex+cross_vec_r*f).x*(25-f)/25;
		out_color.y += tex2D(TextureSampler, in_tex+cross_vec_g*f).y*(25-f)/25;
		out_color.z += tex2D(TextureSampler, in_tex+cross_vec_b*f).z*(25-f)/25;
	}
	
	cross_vec_r = float4(-0.866f/g_texture_width, 0.5f/g_texture_height, 0, 0);
	cross_vec_g = cross_vec_r*0.95f;
	cross_vec_b = cross_vec_r*0.9f;
	for (f=1;f<25;f+=1.0f) {
//		out_color += tex2D(TextureSampler, in_tex+cross_vec_r*f)*(25-f)/25;
		out_color.x += tex2D(TextureSampler, in_tex+cross_vec_r*f).x*(25-f)/25;
		out_color.y += tex2D(TextureSampler, in_tex+cross_vec_g*f).y*(25-f)/25;
		out_color.z += tex2D(TextureSampler, in_tex+cross_vec_b*f).z*(25-f)/25;
	}

	out_color=saturate(out_color);
	out_color.a = in_color.a;		//͂Ȃƃ_ۂ
}

//------------------------------------------------
// eNjbN錾
//------------------------------------------------
technique GraphTech
{
	pass P0	//SHADER_PASS_2DSPRITE
	{
		vertexShader = compile vs_2_0 SpriteVS();
		pixelShader  = compile ps_2_0 SpritePS();
	}
	pass P1	//SHADER_PASS_2DSPRITE_L
	{
		vertexShader = compile vs_2_0 SpriteVS();
		pixelShader  = compile ps_2_0 SpritePS_L();
	}
	pass P2	//SHADER_PASS_2DSPRITE_R
	{
		vertexShader = compile vs_2_0 SpriteVS();
		pixelShader  = compile ps_2_0 SpritePS_R();
	}
	pass P3	//SHADER_PASS_3DSPRITE
	{
		vertexShader = compile vs_2_0 SpriteVS();
		pixelShader  = compile ps_2_0 Sprite3DPS();
	}
	pass P4	//SHADER_PASS_3DMESH
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 MeshPS();
	}
	pass P5	//SHADER_PASS_3DMESH_S
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 MeshPS_S();
	}
	pass P6	//SHADER_PASS_3DMESH_S8
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 MeshPS_S8();
	}
	pass P7	//SHADER_PASS_3DMESH_ENV
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 EnvMeshPS();
	}
	pass P8	//SHADER_PASS_3DMESH_ENV_S
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 EnvMeshPS_S();
	}
	pass P9	//SHADER_PASS_3DMESH_ENV_8
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 EnvMeshPS_S8();
	}
	pass P10	//SHADER_PASS_3DMESH_SHADOW
	{
		vertexShader = compile vs_2_0 ShadowVS();
		pixelShader  = compile ps_2_0 ShadowPS();
	}
	pass P11	//SHADER_PASS_3DMESH_GLARE
	{
		vertexShader = compile vs_3_0 MeshVS();
		pixelShader  = compile ps_3_0 GlarePS();
	}
	pass P12	//SHADER_PASS_SMALL_COPY
	{
		vertexShader = compile vs_2_0 SpriteVS();
		pixelShader  = compile ps_2_0 SmallPS();
	}
	pass P13	//SHADER_PASS_CROSS_COPY
	{
		vertexShader = compile vs_3_0 SpriteVS();
		pixelShader  = compile ps_3_0 CrossPS();
	}

}
